*******************************************************************************
*                         680xx Grundprogramm dos1                            *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                         Mensteuerung fr JADOS                             *
*******************************************************************************


*********************** Diskettenfunktionen unter JADOS ***********************
*      Hier ndern, wenn an anderes Betriebssystem angepasst werden soll      *
*                             Siehe auch dos2.asm                             *
*******************************************************************************

savedisk:                       * Daten auf Disk speichern
 bsr    dostest
 bcs    carset
 lea    menue31(pc),a0
 bsr    menueio
 cmp.b  #'1',d0
 beq.s  savedatei
 cmp.b  #'2',d0
 beq.s  saveedit                * Editordaten speichern
 cmp.b  #'3',d0
 beq    savedruck               * Druckerdaten speichern
rts

savedatei:                      * Datei speichern
 lea    sadadt0(pc),a0
 lea    sadadt1(pc),a1
 move   #180,d3
 bsr    doswerte
 bcs    carset
 bsr    fillfcb                 * Namen eintragen
 bcs    doserr0
 lea    sadadt2(pc),a0
 moveq  #115,d2
 bsr    doswert0
 bcs    carset
 bsr    wertmfeh
 bcs    carset
 movea.l d0,a2                  * Quelladresse merken
 lea    sadadt3(pc),a0
 moveq  #50,d2
 bsr    doswert0
 bcs    carset
 bsr    wertmfeh
 bcs    carset
 subq   #1,d0                   * Anzahl Sektoren minus 1
 move   d0,d1
 lea    einbuf+40(a5),a1
 movea.l a2,a0
 bsr    filesave                * JADOS-Funktion
bra     doserr

saveedit:
 lea    saeddt0(pc),a0          * berschrift
 lea    saeddt1(pc),a1          * Frage-Text
 moveq  #125,d3                 * Y-Koordinate
 bsr    doswerte                * Namen holen
 bcs    carset
saveed0:
 bsr    fillfcb
 bcs    doserr0                 * a1 = Buffer
 bsr    getfrei
 movea.l a0,a2
 move.l #'RDED',(a2)+
 move.l #'ITOR',(a2)+           * Kennung, da es Editordaten sind
 move.b groesse(a5),(a2)+       * Ausgabegre
 move.b insl(a5),d0
 and.b  #%00011001,d0
 move.b d0,(a2)+                * Einfgemode, Scroll-Art, Anfangsposition
 move.b lrand(a5),(a2)+         * Linker Rand
 move.b optflag(a5),(a2)+       * Zeichensatz
 lea    edittabs(a5),a3
 moveq  #80-1,d0
saveed1:
 move.b (a3)+,(a2)+             * Alle Tab-Positionen
dbra    d0,saveed1
 lea    editmacro(a5),a3
 move   #41*10-1,d0
saveed2:
 move.b (a3)+,(a2)+             * Alle Macros des Editors
dbra    d0,saveed2
 move.l #'ENDE',(a2)+           * Endekennung
 moveq  #0,d1                   * 1 Sektor
 bsr    filesave                * JADOS-Funktion
bra     doserr

savedruck:
 lea    sadrdt0(pc),a0          * berschrift
 lea    sadrdt1(pc),a1          * Frage-Text
 moveq  #125,d3                 * Y-Koordinate
 bsr    doswerte                * Namen holen
 bcs    carset
 bsr    fillfcb
 bcs    doserr0                 * a1 = Buffer
 bsr    getfrei
 movea.l a0,a2
 move.l #'RDDR',(a2)+
 move.l #'UCKE',(a2)+           * Kennung, da es Druckerdaten sind
 move.b dflag0(a5),(a2)+        * Druckmodi
 move.b dflag1(a5),(a2)+        * Druckmodi
 move.b dflag2(a5),(a2)+        * Seitenlnge
 move.b dflag3(a5),(a2)+        * Linker Rand
 lea    drbeftab(a5),a3
 moveq  #3*22-1,d0
savedr0:
 move.b (a3)+,(a2)+             * Alle Druckerbefehle
dbra    d0,savedr0
 lea    drsave(a5),a3
 moveq  #20-1,d0
savedr1:
 move.b (a3)+,(a2)+             * Alle eigenen Befehle
dbra    d0,savedr1
 move.l #'ENDE',(a2)+           * Endekennung
 moveq  #0,d1                   * 1 Sektor
 bsr    filesave                * JADOS-Funktion
bra     doserr

loaddisk:                       * Daten von Disk laden
 bsr    dostest
 bcs    carset
 lea    menue31(pc),a0
 bsr    menueio
 cmp.b  #'1',d0
 beq.s  loaddatei
 cmp.b  #'2',d0
 beq.s  loadedit                * Editordaten laden
 cmp.b  #'3',d0
 beq    loaddruck               * Druckerdaten laden
rts

loaddatei:                      * Datei laden
 lea    lodadt0(pc),a0
 lea    lodadt1(pc),a1
 move   #160,d3
 bsr    doswerte
 bcs    carset
 bsr    fillfcb                 * Namen eintragen
 bcs    doserr0
 lea    lodadt2(pc),a0
 moveq  #90,d2
 bsr    doswert0
 bcs    carset
 bsr    wertmfeh
 bcs    carset
 movea.l d0,a0                  * Zieladresse
 lea    einbuf+40(a5),a1
 bsr    fileload                * JADOS-Funktion
bra     doserr

loadedit:
 lea    loeddt0(pc),a0          * berschrift
 lea    loeddt1(pc),a1          * Frage-Text
 moveq  #125,d3                 * Y-Koordinate
 bsr    doswerte                * Namen holen
 bcs    carset
loaded0:
 bsr    fillfcb
 bcs    doserr0                 * a1 = Buffer
 bsr    getfrei
 bsr    fileload                * JADOS-Funktion
 bsr    doserr
 bcs    carset
 cmp.l  #'RDED',(a0)+
 bne    doserr0
 cmp.l  #'ITOR',(a0)+           * Kennung, da es Editordaten sind
 bne    doserr0
 cmp.l  #'ENDE',494(a0)         * Endekennung
 bne    doserr0
 move.b (a0)+,groesse(a5)       * Ausgabegre
 move.b insl(a5),d0
 and.b  #%00000110,d0
 or.b (a0)+,d0                  * Einfgemode, Scroll-Art, Anfangsposition
 move.b d0,insl(a5)
 move.b (a0)+,lrand(a5)         * Linker Rand
 move.b (a0)+,optflag(a5)       * Zeichensatz
 lea    edittabs(a5),a1
 moveq  #80-1,d0
loaded1:
 move.b (a0)+,(a1)+             * Alle Tab-Positionen
dbra    d0,loaded1
 lea    editmacro(a5),a1
 move   #41*10-1,d0
loaded2:
 move.b (a0)+,(a1)+             * Alle Macrotexte
dbra    d0,loaded2
bra     carres

loaddruck:
 lea    lodrdt0(pc),a0          * berschrift
 lea    lodrdt1(pc),a1          * Frage-Text
 moveq  #125,d3                 * Y-Koordinate
 bsr    doswerte                * Namen holen
 bcs    carset
 bsr    fillfcb
 bcs    doserr0                 * a1 = Buffer
 bsr    getfrei
 bsr    fileload                * JADOS-Funktion
 bsr    doserr
 bcs    carset
 cmp.l  #'RDDR',(a0)+
 bne    doserr0
 cmp.l  #'UCKE',(a0)+           * Kennung, da es Druckerdaten sind
 bne    doserr0
 cmp.l  #'ENDE',90(a0)          * Endekennung
 bne    doserr0
 move.b (a0)+,dflag0(a5)        * Druckmodi
 move.b (a0)+,dflag1(a5)        * Druckmodi
 move.b (a0)+,dflag2(a5)        * Seitenlnge
 move.b (a0)+,dflag3(a5)        * Linker Rand
 lea    drbeftab(a5),a1
 moveq  #3*22-1,d0
loaddr0:
 move.b (a0)+,(a1)+             * Alle Druckerbefehle
dbra    d0,loaddr0
 lea    drsave(a5),a1
 moveq  #20-1,d0
loaddr1:
 move.b (a0)+,(a1)+             * Alle eigenen Befehle
dbra    d0,loaddr1
bra     carres

loadfont:
 lea    loftdt0(pc),a0          * berschrift
 lea    loftdt1(pc),a1          * Frage-Text
 moveq  #125,d3                 * Y-Koordinate
 bsr    doswerte                * Namen holen
 bcs    carset
loadft0:
 bsr    fillfcb
 bcs    doserr0                 * a1 = Buffer
 bsr    getfrei
 bsr    fileload                * JADOS-Funktion
 bsr    doserr
 bcs    carset
 cmp.l  #'NKCF',(a0)+
 bne    doserr0
 cmp.l  #'ONT ',(a0)+           * Kennung, da es Fontdaten sind
 bne    doserr0
 cmp.l  #'ENDE',484(a0)         * Endekennung
 bne    doserr0
 movea.l a0, a1                 * Pointer sichern
 addq.l #4, a0                  * auf 1.Zeichen
 moveq #96-1, d3                * Anzahl der Zeichen-1
 move.b #' ', d2                * Bei Space beginnen
loadft1:
 move.b d2, d0
 bsr setchar
 bcs carset                     * Fehler beim Zeichen schreiben
 addq.b #1, d2                  * nchstes Zeichen
 dbra d3, loadft1
 move.l (a1)+, fontname(a5)     * erst zum Schluss, wg. Fehler
bra     carres


inhdisk:                       * Inhaltsverzeichnis ausgeben
 lea    inhdt0(pc),a0
 lea    inhdt1(pc),a1
 moveq  #125,d3
 bsr    doswerte
 bcs    carset
catalog:                        * a1 = Suchmuster
 movea.l a1,a0
 moveq  #11,d7                  * UPPERCAS
 trap   #6
 bsr    getfrei
 move   #$1400,d1               * 5 Kbyte Freiraum
 moveq  #0,d2                   * Nur Name
 moveq  #5,d3                   * 5 Spalten
 move   #1,passflag(a5)         * Keine Ausgabe ber JADOS
 moveq  #74,d7                  * DIRECTORY (JADOS-Funktion)
 trap   #6
 move   #2,passflag(a5)
 bsr    doserr
 bcs    carset
 bsr    clrscreen               * Ausgabe mit CO2
 bsr    prtco
 bsr    crlfe
 moveq  #6,d7                   * RESPONSE (JADOS-Funktion)
 trap   #6
 clr.b  flip(a5)                * Keine Seitenumschaltung
bra     carres

deldatei:                       * Datei lschen
 lea    deldt0(pc),a0
 lea    deldt1(pc),a1
 moveq  #125,d3
 bsr    doswerte
 bcs    carset
 bsr    fillfcb
 bcs    doserr0
 move   #1,passflag(a5)         * Keine Ausgabe ber JADOS
 moveq  #17,d7                  * ERASE (JADOS-Funktion)
 trap   #6
 move   #2,passflag(a5)
bra     doserr

kopdatei:                       * Datei kopieren
 lea    kopdt0(pc),a0
 lea    kopdt1(pc),a1
 lea    kopdt2(pc),a2
 moveq  #15,d6                  * COPYFILE (JADOS-Funktion)
kopdat0:
 move   #160,d3
 bsr    doswerte                * Alten Namen holen
 bcs    carset
 bsr    fillfcb
 bcs    doserr0
 movea.l a2,a0
 moveq  #90,d2
 bsr    doswert0                * Neuer Name
 bcs    carset
 lea    ausbuf(a5),a1
 bsr    fillfcb0
 bcs    doserr0
 lea    einbuf+40(a5),a1
 lea    ausbuf(a5),a2
 move   #1,passflag(a5)         * Keine Ausgabe ber JADOS
 moveq  #58,d7                  * GETLADDR (JADOS-Funktion)
 trap   #6                      * Diese Funktion wird bei rendatei nicht
                                * bentigt, strt aber nicht bei COPYFILE
 move   d6,d7                   * JADOS-Funktion
 trap   #6
 move   #2,passflag(a5)
bra     doserr

rendatei:                       * Datei umbenennen
 lea    rendt0(pc),a0
 lea    rendt1(pc),a1
 lea    rendt2(pc),a2
 moveq  #21,d6                  * RENAME (JADOS-Funktion)
bra.s kopdat0

fillfcb:                        * JADOS-Funktion
 lea    einbuf+40(a5),a1        * Ziel fr Dateisteuerblock
fillfcb0:
 moveq  #11,d7                  * UPPERCAS
 trap   #6
 moveq  #18,d7                  * FILLFCB
 trap   #6
 tst.b  d0
 beq    carres                  * OK
bra     carset                  * Fehler

doswerte:
 bsr    dostest
 bcs    carset
 bsr    headaclr                * berschrift
 movea.l a1,a0
 move   d3,d2
doswert0:
 lea    einbuf+90(a5),a1        * Ziel fr Namen
 moveq  #$33,d0
 moveq  #5,d1
 bsr    textaus                 * Frage-Text
 sub    #25,d2                  * etwas tiefer
 movea.l a1,a0                  * Adresse Ziel
 moveq  #$22,d0
 moveq  #40,d3                  * 40 Zeichen
 bsr    textein                 * Text holen
 bcs    carset                  * Abbruch
 tst    d4
 beq    carset                  * Kein Zeichen, dann Fehler
 movea.l a1,a0
bra     carres                  * Sonst OK

doserr:                         * d0 sind Fehlermglichkeiten
 moveq  #5,d7                   * Floppy-Motoren ausschalten
 trap   #6
 tst.b  d0                      * Fehler ?
 beq    carres                  * Nein
 lea    dostxt2(pc),a0          * Diskette voll
 cmp.b  #2,d0
 beq.s  doserr1
 lea    dostxt3(pc),a0          * Datei nicht vorhanden
 cmp.b  #3,d0
 beq.s  doserr1
 lea    dostxt4(pc),a0          * Neuer Name existiert bereits
 cmp.b  #4,d0
 beq.s  doserr1
 lea    dostxt5(pc),a0          * Diskette voll
 cmp.b  #5,d0
 beq.s  doserr1
 lea    dostxt99(pc),a0         * Nicht genug RAM
 cmp.b  #99,d0
 beq.s  doserr1
doserr0:
 lea    dostxt(pc),a0           * Fehler
doserr1:
 moveq  #$33,d0
 moveq  #10,d2
 bsr    centertxt               * Fehlertext mittig ausgeben
 moveq  #20,d0
 bsr    delay                   * 2 Sekunden warten
bra     carset                  * Fehler

fileload:
 move   #1,passflag(a5)         * Keine Ausgabe ber JADOS
 moveq  #44,d7
 trap   #6
bra.s   files0

filesave:
 move   #1,passflag(a5)         * Keine Ausgabe ber JADOS
 moveq  #45,d7
 trap   #6
files0:
 move   #2,passflag(a5)
rts


                                                                                                                                                                                                                                                                                             'WAIT    '                * 18
 dc.b 'SCHR16TE'                * 19
 dc.b 'CLRSCREE'                * 20
 dc.b 'CO      '                * 21
 dc.b 'LO      '                * 22
 dc.b 'SIN     '                * 23
 dc.b 'COS     '                * 24
 dc.b 'SIZE    '                * 25
 dc.b 'CMD     '                * 26
 dc.b 'NEWPAGE '                * 27
 dc.b 'SYNC    '                * 28
 dc.b 'WERT    '                * 29
 dc.b 'ZUWEIS  '                * 30
 dc.b 'CIINIT2 '        